<?php
// This script and data application was generated by AppGini, https://bigprof.com/appgini
// Download AppGini for free from https://bigprof.com/appgini/download/

	include_once(__DIR__ . '/lib.php');
	@include_once(__DIR__ . '/hooks/item_prices.php');
	include_once(__DIR__ . '/item_prices_dml.php');

	// mm: can the current member access this page?
	$perm = getTablePermissions('item_prices');
	if(!$perm['access']) {
		echo error_message($Translation['tableAccessDenied']);
		exit;
	}

	$x = new DataList;
	$x->TableName = 'item_prices';

	// Fields that can be displayed in the table view
	$x->QueryFieldsTV = [
		"`item_prices`.`id`" => "id",
		"IF(    CHAR_LENGTH(`items1`.`item_description`), CONCAT_WS('',   `items1`.`item_description`), '') /* Item */" => "item",
		"`item_prices`.`price`" => "price",
		"if(`item_prices`.`date`,date_format(`item_prices`.`date`,'%d/%m/%Y'),'')" => "date",
	];
	// mapping incoming sort by requests to actual query fields
	$x->SortFields = [
		1 => '`item_prices`.`id`',
		2 => '`items1`.`item_description`',
		3 => '`item_prices`.`price`',
		4 => '`item_prices`.`date`',
	];

	// Fields that can be displayed in the csv file
	$x->QueryFieldsCSV = [
		"`item_prices`.`id`" => "id",
		"IF(    CHAR_LENGTH(`items1`.`item_description`), CONCAT_WS('',   `items1`.`item_description`), '') /* Item */" => "item",
		"`item_prices`.`price`" => "price",
		"if(`item_prices`.`date`,date_format(`item_prices`.`date`,'%d/%m/%Y'),'')" => "date",
	];
	// Fields that can be filtered
	$x->QueryFieldsFilters = [
		"`item_prices`.`id`" => "ID",
		"IF(    CHAR_LENGTH(`items1`.`item_description`), CONCAT_WS('',   `items1`.`item_description`), '') /* Item */" => "Item",
		"`item_prices`.`price`" => "Price",
		"`item_prices`.`date`" => "Date",
	];

	// Fields that can be quick searched
	$x->QueryFieldsQS = [
		"`item_prices`.`id`" => "id",
		"IF(    CHAR_LENGTH(`items1`.`item_description`), CONCAT_WS('',   `items1`.`item_description`), '') /* Item */" => "item",
		"`item_prices`.`price`" => "price",
		"if(`item_prices`.`date`,date_format(`item_prices`.`date`,'%d/%m/%Y'),'')" => "date",
	];

	// Lookup fields that can be used as filterers
	$x->filterers = ['item' => 'Item', ];

	$x->QueryFrom = "`item_prices` LEFT JOIN `items` as items1 ON `items1`.`id`=`item_prices`.`item` ";
	$x->QueryWhere = '';
	$x->QueryOrder = '';

	$x->AllowSelection = 1;
	$x->HideTableView = ($perm['view'] == 0 ? 1 : 0);
	$x->AllowDelete = $perm['delete'];
	$x->AllowMassDelete = (getLoggedAdmin() !== false);
	$x->AllowInsert = $perm['insert'];
	$x->AllowUpdate = $perm['edit'];
	$x->SeparateDV = 1;
	$x->AllowDeleteOfParents = 0;
	$x->AllowFilters = 1;
	$x->AllowSavingFilters = (getLoggedAdmin() !== false);
	$x->AllowSorting = 1;
	$x->AllowNavigation = 1;
	$x->AllowPrinting = 1;
	$x->AllowPrintingDV = 1;
	$x->AllowCSV = 1;
	$x->AllowAdminShowSQL = 0;
	$x->RecordsPerPage = 10;
	$x->QuickSearch = 1;
	$x->QuickSearchText = $Translation['quick search'];
	$x->ScriptFileName = 'item_prices_view.php';
	$x->RedirectAfterInsert = 'item_prices_view.php?SelectedID=#ID#';
	$x->TableTitle = 'Prices History';
	$x->TableIcon = 'resources/table_icons/card_money.png';
	$x->PrimaryKey = '`item_prices`.`id`';
	$x->DefaultSortField = '`item_prices`.`date`';
	$x->DefaultSortDirection = 'desc';

	$x->ColWidth = [150, 80, 150, ];
	$x->ColCaption = ['Item', 'Price', 'Date', ];
	$x->ColFieldName = ['item', 'price', 'date', ];
	$x->ColNumber  = [2, 3, 4, ];

	// template paths below are based on the app main directory
	$x->Template = 'templates/item_prices_templateTV.html';
	$x->SelectedTemplate = 'templates/item_prices_templateTVS.html';
	$x->TemplateDV = 'templates/item_prices_templateDV.html';
	$x->TemplateDVP = 'templates/item_prices_templateDVP.html';

	$x->ShowTableHeader = 1;
	$x->TVClasses = "";
	$x->DVClasses = "";
	$x->HasCalculatedFields = false;
	$x->AllowConsoleLog = false;
	$x->AllowDVNavigation = true;

	// hook: item_prices_init
	$render = true;
	if(function_exists('item_prices_init')) {
		$args = [];
		$render = item_prices_init($x, getMemberInfo(), $args);
	}

	if($render) $x->Render();

	// hook: item_prices_header
	$headerCode = '';
	if(function_exists('item_prices_header')) {
		$args = [];
		$headerCode = item_prices_header($x->ContentType, getMemberInfo(), $args);
	}

	if(!$headerCode) {
		include_once(__DIR__ . '/header.php'); 
	} else {
		ob_start();
		include_once(__DIR__ . '/header.php');
		echo str_replace('<%%HEADER%%>', ob_get_clean(), $headerCode);
	}

	echo $x->HTML;

	// hook: item_prices_footer
	$footerCode = '';
	if(function_exists('item_prices_footer')) {
		$args = [];
		$footerCode = item_prices_footer($x->ContentType, getMemberInfo(), $args);
	}

	if(!$footerCode) {
		include_once(__DIR__ . '/footer.php'); 
	} else {
		ob_start();
		include_once(__DIR__ . '/footer.php');
		echo str_replace('<%%FOOTER%%>', ob_get_clean(), $footerCode);
	}
