<?php

// Data functions (insert, update, delete, form) for table invoice_items

// This script and data application was generated by AppGini, https://bigprof.com/appgini
// Download AppGini for free from https://bigprof.com/appgini/download/

function invoice_items_insert(&$error_message = '') {
	global $Translation;

	// mm: can member insert record?
	$arrPerm = getTablePermissions('invoice_items');
	if(!$arrPerm['insert']) {
		$error_message = $Translation['no insert permission'];
		return false;
	}

	// automatic invoice if passed as filterer
	if(Request::val('filterer_invoice')) {
		$_REQUEST['invoice'] = Request::val('filterer_invoice');
	}

	$data = [
		'item' => Request::lookup('item', ''),
		'current_price' => Request::lookup('item'),
		'unit_price' => Request::val('unit_price', ''),
		'qty' => Request::val('qty', '1'),
	];


	// automatic invoice if passed as filterer
	if(Request::val('filterer_invoice')) {
		$data['invoice'] = Request::val('filterer_invoice');
	}
	// record owner is current user
	$recordOwner = getLoggedMemberID();

	$recID = tableInsert('invoice_items', $data, $recordOwner, $error_message);

	// if this record is a copy of another record, copy children if applicable
	if(strlen(Request::val('SelectedID')) && $recID !== false)
		invoice_items_copy_children($recID, Request::val('SelectedID'));

	return $recID;
}

function invoice_items_copy_children($destination_id, $source_id) {
	global $Translation;
	$requests = []; // array of curl handlers for launching insert requests
	$eo = ['silentErrors' => true];
	$safe_sid = makeSafe($source_id);
	$currentUsername = getLoggedMemberID();
	$errorMessage = '';

	// launch requests, asynchronously
	curl_batch($requests);
}

function invoice_items_delete($selected_id, $AllowDeleteOfParents = false, $skipChecks = false) {
	// insure referential integrity ...
	global $Translation;
	$selected_id = makeSafe($selected_id);

	// mm: can member delete record?
	if(!check_record_permission('invoice_items', $selected_id, 'delete')) {
		return $Translation['You don\'t have enough permissions to delete this record'];
	}

	// hook: invoice_items_before_delete
	if(function_exists('invoice_items_before_delete')) {
		$args = [];
		if(!invoice_items_before_delete($selected_id, $skipChecks, getMemberInfo(), $args))
			return $Translation['Couldn\'t delete this record'] . (
				!empty($args['error_message']) ?
					'<div class="text-bold">' . strip_tags($args['error_message']) . '</div>'
					: '' 
			);
	}

	sql("DELETE FROM `invoice_items` WHERE `id`='{$selected_id}'", $eo);

	// hook: invoice_items_after_delete
	if(function_exists('invoice_items_after_delete')) {
		$args = [];
		invoice_items_after_delete($selected_id, getMemberInfo(), $args);
	}

	// mm: delete ownership data
	sql("DELETE FROM `membership_userrecords` WHERE `tableName`='invoice_items' AND `pkValue`='{$selected_id}'", $eo);
}

function invoice_items_update(&$selected_id, &$error_message = '') {
	global $Translation;

	// mm: can member edit record?
	if(!check_record_permission('invoice_items', $selected_id, 'edit')) return false;

	$data = [
		'item' => Request::lookup('item', ''),
		'current_price' => Request::lookup('item'),
		'unit_price' => Request::val('unit_price', ''),
		'qty' => Request::val('qty', ''),
	];

	if($data['unit_price'] === '') {
		echo StyleSheet() . "\n\n<div class=\"alert alert-danger\">{$Translation['error:']} 'Unit price': {$Translation['field not null']}<br><br>";
		echo '<a href="" onclick="history.go(-1); return false;">' . $Translation['< back'] . '</a></div>';
		exit;
	}
	// get existing values
	$old_data = getRecord('invoice_items', $selected_id);
	if(is_array($old_data)) {
		$old_data = array_map('makeSafe', $old_data);
		$old_data['selectedID'] = makeSafe($selected_id);
	}

	$data['selectedID'] = makeSafe($selected_id);

	// hook: invoice_items_before_update
	if(function_exists('invoice_items_before_update')) {
		$args = ['old_data' => $old_data];
		if(!invoice_items_before_update($data, getMemberInfo(), $args)) {
			if(isset($args['error_message'])) $error_message = $args['error_message'];
			return false;
		}
	}

	$set = $data; unset($set['selectedID']);
	foreach ($set as $field => $value) {
		$set[$field] = ($value !== '' && $value !== NULL) ? $value : NULL;
	}

	if(!update(
		'invoice_items', 
		backtick_keys_once($set), 
		['`id`' => $selected_id], 
		$error_message
	)) {
		echo $error_message;
		echo '<a href="invoice_items_view.php?SelectedID=' . urlencode($selected_id) . "\">{$Translation['< back']}</a>";
		exit;
	}


	update_calc_fields('invoice_items', $data['selectedID'], calculated_fields()['invoice_items']);

	// hook: invoice_items_after_update
	if(function_exists('invoice_items_after_update')) {
		if($row = getRecord('invoice_items', $data['selectedID'])) $data = array_map('makeSafe', $row);

		$data['selectedID'] = $data['id'];
		$args = ['old_data' => $old_data];
		if(!invoice_items_after_update($data, getMemberInfo(), $args)) return;
	}

	// mm: update record update timestamp
	set_record_owner('invoice_items', $selected_id);
}

function invoice_items_form($selectedId = '', $allowUpdate = true, $allowInsert = true, $allowDelete = true, $separateDV = true, $templateDV = '', $templateDVP = '') {
	// function to return an editable form for a table records
	// and fill it with data of record whose ID is $selectedId. If $selectedId
	// is empty, an empty form is shown, with only an 'Add New'
	// button displayed.

	global $Translation;
	$eo = ['silentErrors' => true];
	$noUploads = $row = $urow = $jsReadOnly = $jsEditable = $lookups = null;
	$noSaveAsCopy = false;
	$hasSelectedId = strlen($selectedId) > 0;

	// mm: get table permissions
	$arrPerm = getTablePermissions('invoice_items');
	$allowInsert = ($arrPerm['insert'] ? true : false);
	$allowUpdate = $hasSelectedId && check_record_permission('invoice_items', $selectedId, 'edit');
	$allowDelete = $hasSelectedId && check_record_permission('invoice_items', $selectedId, 'delete');

	if(!$allowInsert && !$hasSelectedId)
		// no insert permission and no record selected
		// so show access denied error -- except if TVDV: just hide DV
		return $separateDV ? $Translation['tableAccessDenied'] : '';

	if($hasSelectedId && !check_record_permission('invoice_items', $selectedId, 'view'))
		return $Translation['tableAccessDenied'];

	// print preview?
	$dvprint = $hasSelectedId && Request::val('dvprint_x') != '';

	$showSaveNew = !$dvprint && ($allowInsert && !$hasSelectedId);
	$showSaveChanges = !$dvprint && $allowUpdate && $hasSelectedId;
	$showDelete = !$dvprint && $allowDelete && $hasSelectedId;
	$showSaveAsCopy = !$dvprint && ($allowInsert && $hasSelectedId && !$noSaveAsCopy);
	$fieldsAreEditable = !$dvprint && (($allowInsert && !$hasSelectedId) || ($allowUpdate && $hasSelectedId) || $showSaveAsCopy);

	$filterer_invoice = Request::val('filterer_invoice');
	$filterer_item = Request::val('filterer_item');

	// populate filterers, starting from children to grand-parents

	// unique random identifier
	$rnd1 = ($dvprint ? rand(1000000, 9999999) : '');
	// combobox: invoice
	$combo_invoice = new DataCombo;
	// combobox: item
	$combo_item = new DataCombo;

	if($hasSelectedId) {
		if(!($row = getRecord('invoice_items', $selectedId))) {
			return error_message($Translation['No records found'], 'invoice_items_view.php', false);
		}
		$combo_invoice->SelectedData = $row['invoice'];
		$combo_item->SelectedData = $row['item'];
		$urow = $row; /* unsanitized data */
		$row = array_map('safe_html', $row);
	} else {
		$filterField = Request::val('FilterField');
		$filterOperator = Request::val('FilterOperator');
		$filterValue = Request::val('FilterValue');
		$combo_invoice->SelectedData = $filterer_invoice;
		$combo_item->SelectedData = $filterer_item;
	}
	$combo_invoice->HTML = '<span id="invoice-container' . $rnd1 . '"></span><input type="hidden" name="invoice" id="invoice' . $rnd1 . '" value="' . html_attr($combo_invoice->SelectedData) . '">';
	$combo_invoice->MatchText = '<span id="invoice-container-readonly' . $rnd1 . '"></span><input type="hidden" name="invoice" id="invoice' . $rnd1 . '" value="' . html_attr($combo_invoice->SelectedData) . '">';
	$combo_item->HTML = '<span id="item-container' . $rnd1 . '"></span><input type="hidden" name="item" id="item' . $rnd1 . '" value="' . html_attr($combo_item->SelectedData) . '">';
	$combo_item->MatchText = '<span id="item-container-readonly' . $rnd1 . '"></span><input type="hidden" name="item" id="item' . $rnd1 . '" value="' . html_attr($combo_item->SelectedData) . '">';

	ob_start();
	?>

	<script>
		// initial lookup values
		AppGini.current_invoice__RAND__ = { text: "", value: "<?php echo addslashes($hasSelectedId ? $urow['invoice'] : htmlspecialchars($filterer_invoice, ENT_QUOTES)); ?>"};
		AppGini.current_item__RAND__ = { text: "", value: "<?php echo addslashes($hasSelectedId ? $urow['item'] : htmlspecialchars($filterer_item, ENT_QUOTES)); ?>"};

		jQuery(function() {
			setTimeout(function() {
				if(typeof(invoice_reload__RAND__) == 'function') invoice_reload__RAND__();
				if(typeof(item_reload__RAND__) == 'function') item_reload__RAND__();
			}, 50); /* we need to slightly delay client-side execution of the above code to allow AppGini.ajaxCache to work */
		});
		function invoice_reload__RAND__() {
		<?php if($fieldsAreEditable) { ?>

			$j("#invoice-container__RAND__").select2({
				/* initial default value */
				initSelection: function(e, c) {
					$j.ajax({
						url: 'ajax_combo.php',
						dataType: 'json',
						data: { id: AppGini.current_invoice__RAND__.value, t: 'invoice_items', f: 'invoice' },
						success: function(resp) {
							c({
								id: resp.results[0].id,
								text: resp.results[0].text
							});
							$j('[name="invoice"]').val(resp.results[0].id);
							$j('[id=invoice-container-readonly__RAND__]').html('<span class="match-text" id="invoice-match-text">' + resp.results[0].text + '</span>');
							if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=invoices_view_parent]').hide(); } else { $j('.btn[id=invoices_view_parent]').show(); }


							if(typeof(invoice_update_autofills__RAND__) == 'function') invoice_update_autofills__RAND__();
						}
					});
				},
				width: '100%',
				formatNoMatches: function(term) { return '<?php echo addslashes($Translation['No matches found!']); ?>'; },
				minimumResultsForSearch: 5,
				loadMorePadding: 200,
				ajax: {
					url: 'ajax_combo.php',
					dataType: 'json',
					cache: true,
					data: function(term, page) { return { s: term, p: page, t: 'invoice_items', f: 'invoice' }; },
					results: function(resp, page) { return resp; }
				},
				escapeMarkup: function(str) { return str; }
			}).on('change', function(e) {
				AppGini.current_invoice__RAND__.value = e.added.id;
				AppGini.current_invoice__RAND__.text = e.added.text;
				$j('[name="invoice"]').val(e.added.id);
				if(e.added.id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=invoices_view_parent]').hide(); } else { $j('.btn[id=invoices_view_parent]').show(); }


				if(typeof(invoice_update_autofills__RAND__) == 'function') invoice_update_autofills__RAND__();
			});

			if(!$j("#invoice-container__RAND__").length) {
				$j.ajax({
					url: 'ajax_combo.php',
					dataType: 'json',
					data: { id: AppGini.current_invoice__RAND__.value, t: 'invoice_items', f: 'invoice' },
					success: function(resp) {
						$j('[name="invoice"]').val(resp.results[0].id);
						$j('[id=invoice-container-readonly__RAND__]').html('<span class="match-text" id="invoice-match-text">' + resp.results[0].text + '</span>');
						if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=invoices_view_parent]').hide(); } else { $j('.btn[id=invoices_view_parent]').show(); }

						if(typeof(invoice_update_autofills__RAND__) == 'function') invoice_update_autofills__RAND__();
					}
				});
			}

		<?php } else { ?>

			$j.ajax({
				url: 'ajax_combo.php',
				dataType: 'json',
				data: { id: AppGini.current_invoice__RAND__.value, t: 'invoice_items', f: 'invoice' },
				success: function(resp) {
					$j('[id=invoice-container__RAND__], [id=invoice-container-readonly__RAND__]').html('<span class="match-text" id="invoice-match-text">' + resp.results[0].text + '</span>');
					if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=invoices_view_parent]').hide(); } else { $j('.btn[id=invoices_view_parent]').show(); }

					if(typeof(invoice_update_autofills__RAND__) == 'function') invoice_update_autofills__RAND__();
				}
			});
		<?php } ?>

		}
		function item_reload__RAND__() {
		<?php if($fieldsAreEditable) { ?>

			$j("#item-container__RAND__").select2({
				/* initial default value */
				initSelection: function(e, c) {
					$j.ajax({
						url: 'ajax_combo.php',
						dataType: 'json',
						data: { id: AppGini.current_item__RAND__.value, t: 'invoice_items', f: 'item' },
						success: function(resp) {
							c({
								id: resp.results[0].id,
								text: resp.results[0].text
							});
							$j('[name="item"]').val(resp.results[0].id);
							$j('[id=item-container-readonly__RAND__]').html('<span class="match-text" id="item-match-text">' + resp.results[0].text + '</span>');
							if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=items_view_parent]').hide(); } else { $j('.btn[id=items_view_parent]').show(); }


							if(typeof(item_update_autofills__RAND__) == 'function') item_update_autofills__RAND__();
						}
					});
				},
				width: '100%',
				formatNoMatches: function(term) { return '<?php echo addslashes($Translation['No matches found!']); ?>'; },
				minimumResultsForSearch: 5,
				loadMorePadding: 200,
				ajax: {
					url: 'ajax_combo.php',
					dataType: 'json',
					cache: true,
					data: function(term, page) { return { s: term, p: page, t: 'invoice_items', f: 'item' }; },
					results: function(resp, page) { return resp; }
				},
				escapeMarkup: function(str) { return str; }
			}).on('change', function(e) {
				AppGini.current_item__RAND__.value = e.added.id;
				AppGini.current_item__RAND__.text = e.added.text;
				$j('[name="item"]').val(e.added.id);
				if(e.added.id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=items_view_parent]').hide(); } else { $j('.btn[id=items_view_parent]').show(); }


				if(typeof(item_update_autofills__RAND__) == 'function') item_update_autofills__RAND__();
			});

			if(!$j("#item-container__RAND__").length) {
				$j.ajax({
					url: 'ajax_combo.php',
					dataType: 'json',
					data: { id: AppGini.current_item__RAND__.value, t: 'invoice_items', f: 'item' },
					success: function(resp) {
						$j('[name="item"]').val(resp.results[0].id);
						$j('[id=item-container-readonly__RAND__]').html('<span class="match-text" id="item-match-text">' + resp.results[0].text + '</span>');
						if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=items_view_parent]').hide(); } else { $j('.btn[id=items_view_parent]').show(); }

						if(typeof(item_update_autofills__RAND__) == 'function') item_update_autofills__RAND__();
					}
				});
			}

		<?php } else { ?>

			$j.ajax({
				url: 'ajax_combo.php',
				dataType: 'json',
				data: { id: AppGini.current_item__RAND__.value, t: 'invoice_items', f: 'item' },
				success: function(resp) {
					$j('[id=item-container__RAND__], [id=item-container-readonly__RAND__]').html('<span class="match-text" id="item-match-text">' + resp.results[0].text + '</span>');
					if(resp.results[0].id == '<?php echo empty_lookup_value; ?>') { $j('.btn[id=items_view_parent]').hide(); } else { $j('.btn[id=items_view_parent]').show(); }

					if(typeof(item_update_autofills__RAND__) == 'function') item_update_autofills__RAND__();
				}
			});
		<?php } ?>

		}
	</script>
	<?php

	$lookups = str_replace('__RAND__', $rnd1, ob_get_clean());


	// code for template based detail view forms

	// open the detail view template
	if($dvprint) {
		$template_file = is_file("./{$templateDVP}") ? "./{$templateDVP}" : './templates/invoice_items_templateDVP.html';
		$templateCode = @file_get_contents($template_file);
	} else {
		$template_file = is_file("./{$templateDV}") ? "./{$templateDV}" : './templates/invoice_items_templateDV.html';
		$templateCode = @file_get_contents($template_file);
	}

	// process form title
	$templateCode = str_replace('<%%DETAIL_VIEW_TITLE%%>', 'Invoice item details', $templateCode);
	$templateCode = str_replace('<%%RND1%%>', $rnd1, $templateCode);
	$templateCode = str_replace('<%%EMBEDDED%%>', (Request::val('Embedded') ? 'Embedded=1' : ''), $templateCode);
	// process buttons
	if($showSaveNew) {
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '<button type="submit" class="btn btn-success" id="insert" name="insert_x" value="1"><i class="glyphicon glyphicon-plus-sign"></i> ' . $Translation['Save New'] . '</button>', $templateCode);
	} elseif($showSaveAsCopy) {
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="insert" name="insert_x" value="1"><i class="glyphicon glyphicon-plus-sign"></i> ' . $Translation['Save As Copy'] . '</button>', $templateCode);
	} else {
		$templateCode = str_replace('<%%INSERT_BUTTON%%>', '', $templateCode);
	}

	// 'Back' button action
	if(Request::val('Embedded')) {
		$backAction = 'AppGini.closeParentModal(); return false;';
	} else {
		$backAction = 'return true;';
	}

	if($hasSelectedId) {
		if(!Request::val('Embedded')) $templateCode = str_replace('<%%DVPRINT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="dvprint" name="dvprint_x" value="1" title="' . html_attr($Translation['Print Preview']) . '"><i class="glyphicon glyphicon-print"></i> ' . $Translation['Print Preview'] . '</button>', $templateCode);
		if($allowUpdate)
			$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '<button type="submit" class="btn btn-success btn-lg" id="update" name="update_x" value="1" title="' . html_attr($Translation['Save Changes']) . '"><i class="glyphicon glyphicon-ok"></i> ' . $Translation['Save Changes'] . '</button>', $templateCode);
		else
			$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '', $templateCode);

		if($allowDelete)
			$templateCode = str_replace('<%%DELETE_BUTTON%%>', '<button type="submit" class="btn btn-danger" id="delete" name="delete_x" value="1" title="' . html_attr($Translation['Delete']) . '"><i class="glyphicon glyphicon-trash"></i> ' . $Translation['Delete'] . '</button>', $templateCode);
		else
			$templateCode = str_replace('<%%DELETE_BUTTON%%>', '', $templateCode);

		$templateCode = str_replace('<%%DESELECT_BUTTON%%>', '<button type="submit" class="btn btn-default" id="deselect" name="deselect_x" value="1" onclick="' . $backAction . '" title="' . html_attr($Translation['Back']) . '"><i class="glyphicon glyphicon-chevron-left"></i> ' . $Translation['Back'] . '</button>', $templateCode);
	} else {
		$templateCode = str_replace('<%%UPDATE_BUTTON%%>', '', $templateCode);
		$templateCode = str_replace('<%%DELETE_BUTTON%%>', '', $templateCode);

		// if not in embedded mode and user has insert only but no view/update/delete,
		// remove 'back' button
		if(
			$allowInsert
			&& !$allowUpdate && !$allowDelete && !$arrPerm['view']
			&& !Request::val('Embedded')
		)
			$templateCode = str_replace('<%%DESELECT_BUTTON%%>', '', $templateCode);
		elseif($separateDV)
			$templateCode = str_replace(
				'<%%DESELECT_BUTTON%%>', 
				'<button
					type="submit" 
					class="btn btn-default" 
					id="deselect" 
					name="deselect_x" 
					value="1" 
					onclick="' . $backAction . '" 
					title="' . html_attr($Translation['Back']) . '">
						<i class="glyphicon glyphicon-chevron-left"></i> ' .
						$Translation['Back'] .
				'</button>',
				$templateCode
			);
		else
			$templateCode = str_replace('<%%DESELECT_BUTTON%%>', '', $templateCode);
	}

	// set records to read only if user can't insert new records and can't edit current record
	if(!$fieldsAreEditable) {
		$jsReadOnly = '';
		$jsReadOnly .= "\tjQuery('#item').prop('disabled', true).css({ color: '#555', backgroundColor: '#fff' });\n";
		$jsReadOnly .= "\tjQuery('#item_caption').prop('disabled', true).css({ color: '#555', backgroundColor: 'white' });\n";
		$jsReadOnly .= "\tjQuery('#unit_price').replaceWith('<div class=\"form-control-static\" id=\"unit_price\">' + (jQuery('#unit_price').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('#qty').replaceWith('<div class=\"form-control-static\" id=\"qty\">' + (jQuery('#qty').val() || '') + '</div>');\n";
		$jsReadOnly .= "\tjQuery('.select2-container').hide();\n";

		$noUploads = true;
	} else {
		// temporarily disable form change handler till time and datetime pickers are enabled
		$jsEditable = "\tjQuery('form').eq(0).data('already_changed', true);";
		$jsEditable .= "\tjQuery('form').eq(0).data('already_changed', false);"; // re-enable form change handler
	}

	// process combos
	$templateCode = str_replace('<%%COMBO(invoice)%%>', $combo_invoice->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(invoice)%%>', $combo_invoice->MatchText, $templateCode);
	$templateCode = str_replace('<%%URLCOMBOTEXT(invoice)%%>', urlencode($combo_invoice->MatchText), $templateCode);
	$templateCode = str_replace('<%%COMBO(item)%%>', $combo_item->HTML, $templateCode);
	$templateCode = str_replace('<%%COMBOTEXT(item)%%>', $combo_item->MatchText, $templateCode);
	$templateCode = str_replace('<%%URLCOMBOTEXT(item)%%>', urlencode($combo_item->MatchText), $templateCode);

	/* lookup fields array: 'lookup field name' => ['parent table name', 'lookup field caption'] */
	$lookup_fields = ['invoice' => ['invoices', 'Invoice'], 'item' => ['items', 'Item'], ];
	foreach($lookup_fields as $luf => $ptfc) {
		$pt_perm = getTablePermissions($ptfc[0]);

		// process foreign key links
		if(($pt_perm['view'] && isDetailViewEnabled($ptfc[0])) || $pt_perm['edit']) {
			$templateCode = str_replace("<%%PLINK({$luf})%%>", '<button type="button" class="btn btn-default view_parent" id="' . $ptfc[0] . '_view_parent" title="' . html_attr($Translation['View'] . ' ' . $ptfc[1]) . '"><i class="glyphicon glyphicon-eye-open"></i></button>', $templateCode);
		}

		// if user has insert permission to parent table of a lookup field, put an add new button
		if($pt_perm['insert'] /* && !Request::val('Embedded')*/) {
			$templateCode = str_replace("<%%ADDNEW({$ptfc[0]})%%>", '<button type="button" class="btn btn-default add_new_parent" id="' . $ptfc[0] . '_add_new" title="' . html_attr($Translation['Add New'] . ' ' . $ptfc[1]) . '"><i class="glyphicon glyphicon-plus text-success"></i></button>', $templateCode);
		}
	}

	// process images
	$templateCode = str_replace('<%%UPLOADFILE(id)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(invoice)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(item)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(catalog_price)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(unit_price)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(qty)%%>', '', $templateCode);
	$templateCode = str_replace('<%%UPLOADFILE(price)%%>', '', $templateCode);

	// process values
	if($hasSelectedId) {
		$templateCode = str_replace('<%%VALUE(id)%%>', safe_html($urow['id']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id)%%>', urlencode($urow['id']), $templateCode);
		$templateCode = str_replace('<%%VALUE(invoice)%%>', safe_html($urow['invoice']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(invoice)%%>', urlencode($urow['invoice']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(item)%%>', safe_html($urow['item']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(item)%%>', html_attr($row['item']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(item)%%>', urlencode($urow['item']), $templateCode);
		$templateCode = str_replace('<%%VALUE(catalog_price)%%>', safe_html($urow['catalog_price']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(catalog_price)%%>', urlencode($urow['catalog_price']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(unit_price)%%>', safe_html($urow['unit_price']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(unit_price)%%>', html_attr($row['unit_price']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(unit_price)%%>', urlencode($urow['unit_price']), $templateCode);
		if( $dvprint) $templateCode = str_replace('<%%VALUE(qty)%%>', safe_html($urow['qty']), $templateCode);
		if(!$dvprint) $templateCode = str_replace('<%%VALUE(qty)%%>', html_attr($row['qty']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(qty)%%>', urlencode($urow['qty']), $templateCode);
		$templateCode = str_replace('<%%VALUE(price)%%>', safe_html($urow['price']), $templateCode);
		$templateCode = str_replace('<%%URLVALUE(price)%%>', urlencode($urow['price']), $templateCode);
	} else {
		$templateCode = str_replace('<%%VALUE(id)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(id)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(invoice)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(invoice)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(item)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(item)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(catalog_price)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(catalog_price)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(unit_price)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(unit_price)%%>', urlencode(''), $templateCode);
		$templateCode = str_replace('<%%VALUE(qty)%%>', '1', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(qty)%%>', urlencode('1'), $templateCode);
		$templateCode = str_replace('<%%VALUE(price)%%>', '', $templateCode);
		$templateCode = str_replace('<%%URLVALUE(price)%%>', urlencode(''), $templateCode);
	}

	// process translations
	$templateCode = parseTemplate($templateCode);

	// clear scrap
	$templateCode = str_replace('<%%', '<!-- ', $templateCode);
	$templateCode = str_replace('%%>', ' -->', $templateCode);

	// hide links to inaccessible tables
	if(Request::val('dvprint_x') == '') {
		$templateCode .= "\n\n<script>\$j(function() {\n";
		$arrTables = getTableList();
		foreach($arrTables as $name => $caption) {
			$templateCode .= "\t\$j('#{$name}_link').removeClass('hidden');\n";
			$templateCode .= "\t\$j('#xs_{$name}_link').removeClass('hidden');\n";
		}

		$templateCode .= $jsReadOnly;
		$templateCode .= $jsEditable;

		if(!$hasSelectedId) {
		}

		$templateCode.="\n});</script>\n";
	}

	// ajaxed auto-fill fields
	$templateCode .= '<script>';
	$templateCode .= '$j(function() {';

	$templateCode .= "\titem_update_autofills$rnd1 = function() {\n";
	$templateCode .= "\t\t\$j.ajax({\n";
	if($dvprint) {
		$templateCode .= "\t\t\turl: 'invoice_items_autofill.php?rnd1=$rnd1&mfk=item&id=' + encodeURIComponent('".addslashes($row['item'])."'),\n";
		$templateCode .= "\t\t\tcontentType: 'application/x-www-form-urlencoded; charset=" . datalist_db_encoding . "',\n";
		$templateCode .= "\t\t\ttype: 'GET'\n";
	} else {
		$templateCode .= "\t\t\turl: 'invoice_items_autofill.php?rnd1=$rnd1&mfk=item&id=' + encodeURIComponent(AppGini.current_item{$rnd1}.value),\n";
		$templateCode .= "\t\t\tcontentType: 'application/x-www-form-urlencoded; charset=" . datalist_db_encoding . "',\n";
		$templateCode .= "\t\t\ttype: 'GET',\n";
		$templateCode .= "\t\t\tbeforeSend: function() { \$j('#item$rnd1').prop('disabled', true); },\n";
		$templateCode .= "\t\t\tcomplete: function() { " . (($allowInsert || $allowUpdate) ? "\$j('#item$rnd1').prop('disabled', false); " : "\$j('#item$rnd1').prop('disabled', true); ")." \$j(window).resize(); }\n";
	}
	$templateCode .= "\t\t});\n";
	$templateCode .= "\t};\n";
	if(!$dvprint) $templateCode .= "\tif(\$j('#item_caption').length) \$j('#item_caption').click(function() { item_update_autofills$rnd1(); });\n";


	$templateCode.="});";
	$templateCode.="</script>";
	$templateCode .= $lookups;

	// handle enforced parent values for read-only lookup fields
	$filterField = Request::val('FilterField');
	$filterOperator = Request::val('FilterOperator');
	$filterValue = Request::val('FilterValue');
	if(isset($filterField[1]) && $filterField[1] == '2' && $filterOperator[1] == '<=>')
		$templateCode.="\n<input type=hidden name=invoice value=\"" . html_attr($filterValue[1]) . "\">\n";

	// don't include blank images in lightbox gallery
	$templateCode = preg_replace('/blank.gif" data-lightbox=".*?"/', 'blank.gif"', $templateCode);

	// don't display empty email links
	$templateCode=preg_replace('/<a .*?href="mailto:".*?<\/a>/', '', $templateCode);

	/* default field values */
	$rdata = $jdata = get_defaults('invoice_items');
	if($hasSelectedId) {
		$jdata = get_joined_record('invoice_items', $selectedId);
		if($jdata === false) $jdata = get_defaults('invoice_items');
		$rdata = $row;
	}
	$templateCode .= loadView('invoice_items-ajax-cache', ['rdata' => $rdata, 'jdata' => $jdata]);

	// hook: invoice_items_dv
	if(function_exists('invoice_items_dv')) {
		$args = [];
		invoice_items_dv(($hasSelectedId ? $selectedId : FALSE), getMemberInfo(), $templateCode, $args);
	}

	return $templateCode;
}